package ru.yandex.solomon.labels.query;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.re2j.Pattern;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
final class RegexSelector implements Selector {

    private final String key;
    private final String value;
    private final Pattern regexPattern;

    RegexSelector(String key, String value) {
        this.key = key;
        this.value = value;
        this.regexPattern = Pattern.compile(value);
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public String getValue() {
        return value;
    }

    @Override
    public SelectorType getType() {
        return SelectorType.REGEX;
    }

    @Override
    public boolean match(@Nullable String value) {
        return value != null && regexPattern.matcher(value).matches();
    }

    @Override
    public Selector withKey(String key) {
        return new RegexSelector(key, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegexSelector)) {
            return false;
        }

        RegexSelector selector = (RegexSelector) o;

        if (!key.equals(selector.key)) {
            return false;
        }
        return value.equals(selector.value);
    }

    @Override
    public int hashCode() {
        int result = key.hashCode();
        result = 31 * result + value.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "RegexSelector{" +
            "key='" + key + '\'' +
            ", value='" + value + '\'' +
            ", regexPattern=" + regexPattern +
            '}';
    }
}
