package ru.yandex.solomon.labels.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class Selectors0 extends Selectors {
    public static final Selectors0 INSTANCE = new Selectors0("");

    private final String nameSelector;

    Selectors0(String nameSelector) {
        this.nameSelector = nameSelector;
    }

    @Override
    public String getNameSelector() {
        return nameSelector;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return nameSelector.isEmpty();
    }

    @Override
    public Selector at(int index) {
        throw new IndexOutOfBoundsException(String.format("index: %d, is out of [0, 0)", index));
    }

    @Nullable
    @Override
    public Selector findByKey(String key) {
        return null;
    }

    @Nonnull
    @Override
    public Iterator<Selector> iterator() {
        return toList().iterator();
    }

    @Override
    public Stream<Selector> stream() {
        return Stream.of();
    }

    @Override
    public boolean hasKey(String key) {
        return false;
    }

    @Override
    public SelectorsBuilder toBuilder() {
        return new SelectorsBuilder(nameSelector, 0);
    }

    @Override
    public List<Selector> toList() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Selectors0 that = (Selectors0) o;
        return nameSelector.equals(that.nameSelector);
    }

    @Override
    public int hashCode() {
        return nameSelector.hashCode();
    }
}
