package ru.yandex.solomon.labels.query;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Iterators;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class SelectorsArray extends Selectors {
    private final String nameSelector;
    private final Selector[] selectors;

    SelectorsArray(String nameSelector, Selector[] selectors) {
        this.nameSelector = nameSelector;
        this.selectors = selectors;
    }

    @Override
    public String getNameSelector() {
        return nameSelector;
    }

    @Override
    public int size() {
        return selectors.length;
    }

    @Override
    public boolean isEmpty() {
        return nameSelector.isEmpty() && selectors.length == 0;
    }

    @Override
    public Selector at(int index) {
        return selectors[index];
    }

    @Nullable
    @Override
    public Selector findByKey(String key) {
        for (Selector selector : selectors) {
            if (selector.getKey().equals(key)) {
                return selector;
            }
        }
        return null;
    }

    @Nonnull
    @Override
    public Iterator<Selector> iterator() {
        return Iterators.forArray(selectors);
    }

    public Stream<Selector> stream() {
        return Stream.of(selectors);
    }

    @Override
    public boolean hasKey(String key) {
        for (Selector selector : selectors) {
            if (selector.getKey().equals(key)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public SelectorsBuilder toBuilder() {
        return new SelectorsBuilder(nameSelector, Arrays.asList(selectors));
    }

    @Override
    public List<Selector> toList() {
        return Arrays.asList(selectors);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SelectorsArray that = (SelectorsArray) o;

        if (!nameSelector.equals(that.nameSelector)) {
            return false;
        }
        return Arrays.equals(selectors, that.selectors);
    }

    @Override
    public int hashCode() {
        int result = nameSelector.hashCode();
        result = 31 * result + Arrays.hashCode(selectors);
        return result;
    }
}
