package ru.yandex.solomon.labels.query;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;

import ru.yandex.monlib.metrics.labels.Labels;


/**
 * @author Vladimir Gordiychuk
 */
class SelectorsStaticPart {
    /**
     * Parses selectors text query
     *
     * @param text selectors query in text format
     */
    public static Selectors parse(String text) {
        return SelectorsFormat.parse(text);
    }

    public static String format(Selectors selectors) {
        return SelectorsFormat.format(selectors);
    }

    public static Selectors of() {
        return Selectors0.INSTANCE;
    }

    public static Selectors of(Selector selector) {
        return builder(1)
                .add(selector)
                .build();
    }

    public static Selectors of(Selector... other) {
        return builder(Arrays.asList(other))
                .build();
    }

    public static Selectors of(String nameSelector, List<Selector> other) {
        return builder(nameSelector, other).build();
    }

    public static Selectors of(String nameSelector, Selector... other) {
        return builder(Arrays.asList(other))
                .setNameSelector(nameSelector)
                .build();
    }

    public static Selectors of(List<Selector> selectors) {
        return builder(selectors)
                .build();
    }

    public static Selectors of(Labels labels) {
        if (labels.isEmpty()) {
            return Selectors0.INSTANCE;
        }
        SelectorsBuilder builder = builder(labels.size());
        labels.forEach(l -> builder.add(l.getKey(), l.getValue()));
        return builder.build();
    }

    public static Selectors of(Map<String, String> strMap) {
        if (strMap.isEmpty()) {
            return Selectors0.INSTANCE;
        }
        SelectorsBuilder builder = builder(strMap.size());
        for (Map.Entry<String, String> e : strMap.entrySet()) {
            builder.add(e.getKey(), e.getValue());
        }
        return builder.build();
    }

    // Old builders for back comparatively
    public static SelectorsBuilder builder() {
        return builder(5);
    }

    public static SelectorsBuilder builder(int capacity) {
        return new SelectorsBuilder("", capacity);
    }

    public static SelectorsBuilder builder(List<Selector> selectors) {
        return new SelectorsBuilder("", selectors);
    }

    // New builders
    public static SelectorsBuilder builder(String nameSelector) {
        return builder(nameSelector, 5);
    }

    public static SelectorsBuilder builder(String nameSelector, int capacity) {
        return new SelectorsBuilder(nameSelector, capacity);
    }

    public static SelectorsBuilder builder(String nameSelector, List<Selector> selectors) {
        return new SelectorsBuilder(nameSelector, selectors);
    }

    public static Collector<Selector, SelectorsBuilder, Selectors> collector() {
        return Collector.of(SelectorsStaticPart::builder,
                SelectorsBuilder::add,
                SelectorsBuilder::combine,
                SelectorsBuilder::build);
    }
}
