package ru.yandex.solomon.labels.query.matchers;

import java.util.Map;
import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;


/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class AbsentGlobMatcher implements GlobMatcher {
    public static final AbsentGlobMatcher INSTANCE = new AbsentGlobMatcher();

    private AbsentGlobMatcher() {
    }

    @Override
    public boolean matches(@Nullable String value) {
        return value == null;
    }

    @Override
    public <T> void forEachMatchedKey(Map<String, T> values, Consumer<T> fn) {
        // nop, because we do not store null values in index
    }
}
