package ru.yandex.solomon.labels.query.matchers;

import java.util.Map;
import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;


/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class AnyGlobMatcher implements GlobMatcher {
    public static AnyGlobMatcher INSTANCE = new AnyGlobMatcher();

    private AnyGlobMatcher() {
    }

    @Override
    public boolean matches(@Nullable String value) {
        return value != null;
    }

    @Override
    public <T> void forEachMatchedKey(Map<String, T> values, Consumer<T> fn) {
        values.values().forEach(fn);
    }
}
