package ru.yandex.solomon.labels.query.matchers;

import java.util.Map;
import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class ExactGlobMatcher implements GlobMatcher {

    private final String pattern;

    ExactGlobMatcher(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean matches(@Nullable String value) {
        return this.pattern.equals(value);
    }

    @Override
    public <T> void forEachMatchedKey(Map<String, T> values, Consumer<T> fn) {
        T v = values.get(pattern);
        if (v != null) {
            fn.accept(v);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExactGlobMatcher)) {
            return false;
        }

        ExactGlobMatcher that = (ExactGlobMatcher) o;

        return pattern.equals(that.pattern);
    }

    @Override
    public int hashCode() {
        return pattern.hashCode();
    }

    @Override
    public String toString() {
        return "ExactGlobMatcher{" +
            "pattern='" + pattern + '\'' +
            '}';
    }
}
