package ru.yandex.solomon.labels.query.matchers;

import java.util.Map;
import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.LabelValueGlob;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface GlobMatcher {

    boolean matches(@Nullable String value);

    default boolean isExact() {
        return this instanceof ExactGlobMatcher;
    }

    default <T> void forEachMatchedKey(Map<String, T> values, Consumer<T> fn) {
        for (Map.Entry<String, T> e : values.entrySet()) {
            if (matches(e.getKey())) {
                fn.accept(e.getValue());
            }
        }
    }

    static GlobMatcher from(String pattern) {
        if (pattern.contains("|")) {
            return new MultiGlobMatcher(pattern);
        }

        if (LabelValueGlob.isGlob(pattern)) {
            return new SingleGlobMatcher(pattern);
        }

        return new ExactGlobMatcher(pattern);
    }
}
