package ru.yandex.solomon.labels.query.matchers;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.LabelValueGlob;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class SingleGlobMatcher implements GlobMatcher {

    private final String pattern;

    SingleGlobMatcher(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean matches(@Nullable String value) {
        return value != null && LabelValueGlob.match(pattern, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleGlobMatcher)) {
            return false;
        }

        SingleGlobMatcher that = (SingleGlobMatcher) o;

        return pattern.equals(that.pattern);
    }

    @Override
    public int hashCode() {
        return pattern.hashCode();
    }

    @Override
    public String toString() {
        return "SingleGlobMatcher{" +
            "pattern='" + pattern + '\'' +
            '}';
    }
}
