package ru.yandex.solomon.labels.selector;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class LabelSelectorSetParsed {

    private final LabelSelectorParsed[] selectors;

    public LabelSelectorSetParsed(List<LabelSelectorParsed> selectors) {
        this.selectors = selectors.toArray(new LabelSelectorParsed[selectors.size()]);
    }

    public boolean matchesAll(Labels labels) {
        for (LabelSelectorParsed selector : selectors) {
            if (!selector.matches(labels)) {
                return false;
            }
        }
        return true;
    }

    public boolean isEmpty() {
        return selectors.length == 0;
    }
}
