package ru.yandex.solomon.labels.shard;

import java.util.LinkedHashMap;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.LabelKeys;


/**
 * @author Stepan Koltsov
 */
public class ShardKeyAndMetricKey {
    private final ShardKey shardKey;
    private final Labels keyAfterShard;

    public ShardKeyAndMetricKey(ShardKey shardKey, Labels labels) {
        this.shardKey = shardKey;
        this.keyAfterShard = labels;
    }

    public ShardKey getShardKey() {
        return shardKey;
    }

    public Labels getLabelList() {
        return shardKey.toLabels().addAll(keyAfterShard);
    }

    public LinkedHashMap<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<>(keyAfterShard.size() + 3);
        map.put(LabelKeys.PROJECT, shardKey.getProject());
        map.put(LabelKeys.CLUSTER, shardKey.getCluster());
        map.put(LabelKeys.SERVICE, shardKey.getService());
        keyAfterShard.forEach(l -> {
            map.put(l.getKey(), l.getValue());
        });
        return map;
    }

    @Override
    public String toString() {
        return getLabelList().toString();
    }
}
