package ru.yandex.solomon.main.logger;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;

/**
 * @author Sergey Polovko
 */
public class DevNullPrintStream extends PrintStream {
    public static final DevNullPrintStream INSTANCE = new DevNullPrintStream();

    public DevNullPrintStream() {
        super(new OutputStream() {
            @Override
            public void write(int b) {}
        });
    }

    // to avoid locking inside base class methods override them all

    @Override
    public void flush() {
        // nop
    }

    @Override
    public void close() {
        // nop
    }

    @Override
    public boolean checkError() {
        // nop
        return false;
    }

    @Override
    protected void setError() {
        // nop
    }

    @Override
    protected void clearError() {
        // nop
    }

    @Override
    public void write(int b) {
        // nop
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        // nop
    }

    @Override
    public void write(byte[] buf) throws IOException {
        // nop
    }

    @Override
    public void writeBytes(byte[] buf) {
        // nop
    }

    @Override
    public void print(boolean b) {
        // nop
    }

    @Override
    public void print(char c) {
        // nop
    }

    @Override
    public void print(int i) {
        // nop
    }

    @Override
    public void print(long l) {
        // nop
    }

    @Override
    public void print(float f) {
        // nop
    }

    @Override
    public void print(double d) {
        // nop
    }

    @Override
    public void print(char[] s) {
        // nop
    }

    @Override
    public void print(String s) {
        // nop
    }

    @Override
    public void print(Object obj) {
        // nop
    }

    @Override
    public void println() {
        // nop
    }

    @Override
    public void println(boolean x) {
        // nop
    }

    @Override
    public void println(char x) {
        // nop
    }

    @Override
    public void println(int x) {
        // nop
    }

    @Override
    public void println(long x) {
        // nop
    }

    @Override
    public void println(float x) {
        // nop
    }

    @Override
    public void println(double x) {
        // nop
    }

    @Override
    public void println(char[] x) {
        // nop
    }

    @Override
    public void println(String x) {
        // nop
    }

    @Override
    public void println(Object x) {
        // nop
    }

    @Override
    public PrintStream printf(String format, Object... args) {
        // nop
        return this;
    }

    @Override
    public PrintStream printf(Locale l, String format, Object... args) {
        // nop
        return this;
    }

    @Override
    public PrintStream format(String format, Object... args) {
        // nop
        return this;
    }

    @Override
    public PrintStream format(Locale l, String format, Object... args) {
        // nop
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        // nop
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        // nop
        return this;
    }

    @Override
    public PrintStream append(char c) {
        // nop
        return this;
    }
}
