package ru.yandex.solomon.main.logger;

import java.util.concurrent.atomic.AtomicBoolean;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;


/**
 * @author Sergey Polovko
 */
public class SignalTriggeringPolicy implements TriggeringPolicy {

    private final AtomicBoolean signalReceived = new AtomicBoolean();

    @Override
    public void initialize(RollingFileManager manager) {
    }

    @Override
    public boolean isTriggeringEvent(LogEvent logEvent) {
        return signalReceived.get() && signalReceived.compareAndSet(true, false);
    }

    public void onSignal() {
        signalReceived.set(true);
    }
}
