package ru.yandex.solomon.memory.layout;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;


/**
 * @author Stepan Koltsov
 */
public class MemInfoMetricSupplier implements MetricSupplier {
    private static final Logger logger = LoggerFactory.getLogger(MemInfoMetricSupplier.class);

    private final List<MemInfoProvider> providers;
    private volatile int metrics;

    public MemInfoMetricSupplier(List<MemInfoProvider> providers) {
        this.providers = providers;
    }

    @Override
    public int estimateCount() {
        return metrics;
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        if (providers.isEmpty()) {
            return;
        }

        MemoryBySubsystem info = new MemoryBySubsystem();
        for (MemInfoProvider memInfoProvider : providers) {
            try {
                info.addAllMemory(memInfoProvider.memoryBySystem());
            } catch (Exception e) {
                logger.warn("failed to get memory usage info", e);
            }
        }

        info.append(tsMillis, commonLabels, consumer);
        metrics = info.estimateCount();
    }
}
