package ru.yandex.solomon.memory.layout;

import javax.annotation.Nullable;

/**
 * @author Stepan Koltsov
 */
public interface MemMeasurable {
    long memorySizeIncludingSelf();

    static long memorySizeOfNullable(@Nullable MemMeasurable o) {
        return o != null ? o.memorySizeIncludingSelf() : 0;
    }

    default int memorySizeIncludingSelfInt() {
        return Math.toIntExact(memorySizeIncludingSelf());
    }
}
