package ru.yandex.solomon.memory.layout;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
@NotThreadSafe
public class MemoryBySubsystem implements MetricSupplier {

    private Object2LongOpenHashMap<String> memoryBySystem = new Object2LongOpenHashMap<>();
    private long total;

    public Object2LongOpenHashMap<String> getMemoryBySystem() {
        return memoryBySystem;
    }

    public void addMemory(String subsystem, long count) {
        if (count < 0) {
            throw new IllegalArgumentException("negative count(" + count + ") from subsystem(" + subsystem + ')');
        }

        memoryBySystem.addTo(subsystem, count);
        total += count;
    }

    public void addMemory(Class<?> key, long count) {
        addMemory(key.getSimpleName(), count);
    }

    public void addAllMemory(MemoryBySubsystem that) {
        for (Object2LongMap.Entry<String> entry : that.memoryBySystem.object2LongEntrySet()) {
            addMemory(entry.getKey(), entry.getLongValue());
        }
    }

    public long total() {
        return total;
    }

    @Override
    public int estimateCount() {
        return memoryBySystem.size();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        LabelsBuilder labels = commonLabels.toBuilder();
        labels.add("sensor", "memoryUsage");

        for (Object2LongMap.Entry<String> entry : memoryBySystem.object2LongEntrySet()) {
            labels.add("group", entry.getKey());

            consumer.onMetricBegin(MetricType.IGAUGE);
            {
                consumer.onLabelsBegin(labels.size());
                labels.forEach(consumer::onLabel);
                consumer.onLabelsEnd();
            }
            consumer.onLong(tsMillis, entry.getLongValue());
            consumer.onMetricEnd();
        }
    }
}
