package ru.yandex.metabase.client;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneResponse;
import ru.yandex.solomon.metabase.api.protobuf.DeleteManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.DeleteManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.FindRequest;
import ru.yandex.solomon.metabase.api.protobuf.FindResponse;
import ru.yandex.solomon.metabase.api.protobuf.MetricNamesRequest;
import ru.yandex.solomon.metabase.api.protobuf.MetricNamesResponse;
import ru.yandex.solomon.metabase.api.protobuf.ResolveManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.ResolveManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.ResolveOneRequest;
import ru.yandex.solomon.metabase.api.protobuf.ResolveOneResponse;
import ru.yandex.solomon.metabase.api.protobuf.TLabelNamesRequest;
import ru.yandex.solomon.metabase.api.protobuf.TLabelNamesResponse;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValuesRequest;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValuesResponse;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsResponse;
import ru.yandex.solomon.metabase.api.protobuf.TUniqueLabelsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TUniqueLabelsResponse;
import ru.yandex.solomon.selfmon.AvailabilityStatus;


/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public interface MetabaseClient extends AutoCloseable {
    /**
     * Create single metric with specified settings
     */
    CompletableFuture<CreateOneResponse> createOne(CreateOneRequest request);

    /**
     * Create multiple metrics with specified settings
     */
    CompletableFuture<CreateManyResponse> createMany(CreateManyRequest request);

    /**
     * Resolve metric id by unique label list sequence
     */
    CompletableFuture<ResolveOneResponse> resolveOne(ResolveOneRequest request);

    /**
     * Resolve multiple metrics by unique label list sequences
     * Response will contains only exists metrics
     */
    CompletableFuture<ResolveManyResponse> resolveMany(ResolveManyRequest request);

    /**
     * Delete metrics by identity.
     * {@link ru.yandex.solomon.metabase.api.protobuf.EMetabaseStatusCode#OK} when all specified
     * metrics successfully deleted
     * <b>Note:</b> delete it's not atomic oprations and if request failed with timeout or any other
     * errors part of the metrics will be still removed from storage.
     */
    CompletableFuture<DeleteManyResponse> deleteMany(DeleteManyRequest request);

    /**
     * Find metrics by label selector, recommend specify next labels to speed up search:
     * project, cluster, service. But it's not required.
     */
    CompletableFuture<MetricNamesResponse> metricNames(MetricNamesRequest request);

    /**
     * Find metrics by label selector, recommend specify next labels to speed up search:
     * project, cluster, service. But it's not required.
     */
    CompletableFuture<FindResponse> find(FindRequest request);

    /**
     * Find available values for labels by speicifed selector, recommend specify next labels
     * to speed up search: project, cluster, service. But it's not required.
     */
    CompletableFuture<TLabelValuesResponse> labelValues(TLabelValuesRequest request);

    /**
     * Find available values for labels by speicifed selector, recommend specify next labels
     * to speed up search: project, cluster, service. But it's not required.
     */
    CompletableFuture<TLabelNamesResponse> labelNames(TLabelNamesRequest request);

    /**
     * Find unique labels by specified selectors.
     */
    CompletableFuture<TUniqueLabelsResponse> uniqueLabels(TUniqueLabelsRequest request);

    /**
     * Resolve or create metrics from logs meta
     */
    CompletableFuture<TResolveLogsResponse> resolveLogs(TResolveLogsRequest request);

    /**
     * Force update cluster status. This operation can be necessary only if client code know about
     * changes on server side, that not each fetched to client.
     */
    CompletableFuture<Void> forceUpdateClusterMetaData();

    /**
     * @return from 0 to 1 where 1 means that everything ready to accept requests
     */
    AvailabilityStatus getAvailability();

    Stream<Labels> shards(Selectors selectors);

    /**
     * @return true if shard quota on metrics count not reached, otherwise return false
     */
    boolean isAllowCreateNew(int numId);

    @Override
    void close();
}
