package ru.yandex.metabase.client;

import java.util.List;
import java.util.stream.Collectors;

import com.google.common.net.HostAndPort;

import ru.yandex.metabase.client.impl.GrpcMetabaseClient;

/**
 * @author Vladimir Gordiychuk
 */
public final class MetabaseClients {
    private MetabaseClients() {
    }

    public static MetabaseClient create(List<HostAndPort> addresses) {
        return create(addresses, MetabaseClientOptions.empty());
    }

    public static MetabaseClient create(List<HostAndPort> addresses, MetabaseClientOptions options) {
        var addressStr = addresses.stream()
                .map(HostAndPort::toString)
                .collect(Collectors.toList());
        return createDynamic(addressStr, options);
    }

    public static MetabaseClient createDynamic(List<String> addresses, MetabaseClientOptions options) {
        return new GrpcMetabaseClient(addresses, options);
    }
}
