package ru.yandex.metabase.client.impl;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.metabase.client.MetabaseClient;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneRequest;
import ru.yandex.solomon.metabase.api.protobuf.CreateOneResponse;
import ru.yandex.solomon.metabase.api.protobuf.DeleteManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.DeleteManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.EMetabaseStatusCode;
import ru.yandex.solomon.metabase.api.protobuf.FindRequest;
import ru.yandex.solomon.metabase.api.protobuf.FindResponse;
import ru.yandex.solomon.metabase.api.protobuf.MetricNamesRequest;
import ru.yandex.solomon.metabase.api.protobuf.MetricNamesResponse;
import ru.yandex.solomon.metabase.api.protobuf.ResolveManyRequest;
import ru.yandex.solomon.metabase.api.protobuf.ResolveManyResponse;
import ru.yandex.solomon.metabase.api.protobuf.ResolveOneRequest;
import ru.yandex.solomon.metabase.api.protobuf.ResolveOneResponse;
import ru.yandex.solomon.metabase.api.protobuf.TLabelNamesRequest;
import ru.yandex.solomon.metabase.api.protobuf.TLabelNamesResponse;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValuesRequest;
import ru.yandex.solomon.metabase.api.protobuf.TLabelValuesResponse;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TResolveLogsResponse;
import ru.yandex.solomon.metabase.api.protobuf.TUniqueLabelsRequest;
import ru.yandex.solomon.metabase.api.protobuf.TUniqueLabelsResponse;
import ru.yandex.solomon.selfmon.AvailabilityStatus;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class AbstractMetabaseClient implements MetabaseClient {

    @Override
    public CompletableFuture<FindResponse> find(FindRequest request) {
        return CompletableFuture.completedFuture(FindResponse.newBuilder()
                .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
                .setStatusMessage("Unsupported operation")
                .build());
    }

    @Override
    public CompletableFuture<TLabelValuesResponse> labelValues(TLabelValuesRequest request) {
        return CompletableFuture.completedFuture(TLabelValuesResponse.newBuilder()
                .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
                .setStatusMessage("Unsupported operation")
                .build());
    }

    @Override
    public CompletableFuture<TLabelNamesResponse> labelNames(TLabelNamesRequest request) {
        return CompletableFuture.completedFuture(TLabelNamesResponse.newBuilder()
            .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
            .setStatusMessage("Unsupported operation")
            .build());
    }

    @Override
    public CompletableFuture<TUniqueLabelsResponse> uniqueLabels(TUniqueLabelsRequest request) {
        return CompletableFuture.completedFuture(TUniqueLabelsResponse.newBuilder()
                .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
                .setStatusMessage("Unsupported operation")
                .build());
    }

    @Override
    public CompletableFuture<CreateOneResponse> createOne(CreateOneRequest request) {
        return CompletableFuture.completedFuture(CreateOneResponse.newBuilder()
                .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
                .setStatusMessage("Unsupported operation")
                .build());
    }

    @Override
    public CompletableFuture<CreateManyResponse> createMany(CreateManyRequest request) {
        return CompletableFuture.completedFuture(CreateManyResponse.newBuilder()
                .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
                .setStatusMessage("Unsupported operation")
                .build());
    }

    @Override
    public CompletableFuture<ResolveOneResponse> resolveOne(ResolveOneRequest request) {
        return CompletableFuture.completedFuture(ResolveOneResponse.newBuilder()
                .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
                .setStatusMessage("Unsupported operation")
                .build());
    }

    @Override
    public CompletableFuture<ResolveManyResponse> resolveMany(ResolveManyRequest request) {
        return CompletableFuture.completedFuture(ResolveManyResponse.newBuilder()
                .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
                .setStatusMessage("Unsupported operation")
                .build());
    }

    @Override
    public CompletableFuture<DeleteManyResponse> deleteMany(DeleteManyRequest request) {
        return CompletableFuture.completedFuture(DeleteManyResponse.newBuilder()
                .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
                .setStatusMessage("Unsupported operation")
                .build());
    }

    @Override
    public CompletableFuture<MetricNamesResponse> metricNames(MetricNamesRequest request) {
        return CompletableFuture.completedFuture(MetricNamesResponse.newBuilder()
            .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
            .setStatusMessage("Unsupported operation")
            .build());
    }

    @Override
    public CompletableFuture<TResolveLogsResponse> resolveLogs(TResolveLogsRequest request) {
        return CompletableFuture.completedFuture(TResolveLogsResponse.newBuilder()
            .setStatus(EMetabaseStatusCode.INTERNAL_ERROR)
            .setStatusMessage("Unsupported operation")
            .build());
    }

    @Override
    public CompletableFuture<Void> forceUpdateClusterMetaData() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public AvailabilityStatus getAvailability() {
        return AvailabilityStatus.AVAILABLE;
    }

    @Override
    public Stream<Labels> shards(Selectors selectors) {
        return Stream.empty();
    }

    @Override
    public boolean isAllowCreateNew(int numId) {
        return true;
    }

    @Override
    public void close() {

    }
}
