package ru.yandex.metabase.client.impl;

import io.grpc.Status;

import ru.yandex.solomon.metabase.api.protobuf.EMetabaseStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
public class GrpcStatusMapping {

    public static EMetabaseStatusCode toMetabaseStatusCode(Status.Code code) {
        return switch (code) {
            case UNAVAILABLE -> EMetabaseStatusCode.NODE_UNAVAILABLE;
            case DEADLINE_EXCEEDED -> EMetabaseStatusCode.DEADLINE_EXCEEDED;
            case NOT_FOUND -> EMetabaseStatusCode.NOT_FOUND;
            case FAILED_PRECONDITION -> EMetabaseStatusCode.INVALID_REQUEST;
            case RESOURCE_EXHAUSTED -> EMetabaseStatusCode.RESOURCE_EXHAUSTED;
            case OK -> EMetabaseStatusCode.OK;
            case INTERNAL -> EMetabaseStatusCode.INTERNAL_ERROR;
            case CANCELLED -> EMetabaseStatusCode.INVALID_REQUEST;
            default -> EMetabaseStatusCode.INTERNAL_ERROR;
        };
    }
}
