package ru.yandex.metabase.client.impl;

import java.util.stream.IntStream;
import java.util.stream.Stream;

import javax.annotation.Nullable;

import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Egor Litvinenko
 */
public interface PartitionedShard {

    ShardKey getKey();
    @Nullable
    String getFqdn(int partitionId);
    int getNumId();
    int getTotalPartitions();
    long getGenerationId();

    PartitionKey withOnePartition(int partitionId);

    IntStream partitionStream();

    default Stream<PartitionKey> partitionKeyStream() {
        return partitionStream().mapToObj(partitionId -> new PartitionKey(this, partitionId));
    }

}
