package ru.yandex.metabase.client.impl;

import com.google.common.base.MoreObjects;

import ru.yandex.solomon.metabase.api.protobuf.EMetabaseStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
class RequestStatus {
    private final EMetabaseStatusCode code;
    private final String details;

    RequestStatus(EMetabaseStatusCode code, String details) {
        this.code = code;
        this.details = details;
    }

    public EMetabaseStatusCode getCode() {
        return code;
    }

    public String getDetails() {
        return details;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("code", code)
                .add("details", details)
                .toString();
    }
}
