package ru.yandex.solomon.metrics.client;

import javax.annotation.Nonnull;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.solomon.selfmon.AvailabilityStatus;
import ru.yandex.solomon.staffOnly.manager.ok.OkProvider;

/**
 * @author Vladimir Gordiychuk
 */
public class CheckerMetabase implements OkProvider {
    private static final Logger logger = LoggerFactory.getLogger(CheckerMetabase.class);
    private final MetricsClient client;

    public CheckerMetabase(MetricsClient client) {
        this.client = client;
    }

    @Override
    public String getCheckName() {
        return "metabase.client.readiness";
    }

    @Nonnull
    @Override
    public Status[] statuses() {
        return new Status[]{check()};
    }

    public Status check() {
        AvailabilityStatus status = client.getMetabaseAvailability();
        boolean ok = Double.compare(status.getAvailability(), 1.0) >= 0;
        return status(ok, status.getDetails());
    }

    private Status status(boolean ok, String message) {
        return new Status(CheckerMetabase.class.getSimpleName(), ok, message);
    }
}
