package ru.yandex.solomon.metrics.client;

import javax.annotation.Nonnull;

import ru.yandex.solomon.selfmon.AvailabilityStatus;
import ru.yandex.solomon.staffOnly.manager.ok.OkProvider;

/**
 * @author Vladimir Gordiychuk
 */
public class CheckerStockpile implements OkProvider {
    private final MetricsClient client;

    public CheckerStockpile(MetricsClient client) {
        this.client = client;
    }

    @Override
    public String getCheckName() {
        return "stockpile.client.readiness";
    }

    @Nonnull
    @Override
    public Status[] statuses() {
        return new Status[]{check()};
    }

    public Status check() {
        AvailabilityStatus status = client.getStockpileAvailability();
        boolean ok = Double.compare(status.getAvailability(), 1.0) >= 0;
        return status(ok, status.getDetails());
    }

    private Status status(boolean ok, String message) {
        return new Status(CheckerStockpile.class.getSimpleName(), ok, message);
    }
}
