package ru.yandex.solomon.metrics.client;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

import ru.yandex.solomon.model.MetricKey;

/**
 * @author Vladimir Gordiychuk
 */
public class CrossShardResponseMerger {

    private CrossShardResponseMerger() {
    }

    public static FindResponse mergeFindResponses(List<FindResponse> responses, int limit) {
        switch (responses.size()) {
            case 0:
                return new FindResponse(MetabaseStatus.OK);
            case 1:
                return Iterables.getOnlyElement(responses);
        }

        for (var response : responses) {
            if (!response.isOk()) {
                return response;
            }
        }

        List<MetricKey> metrics = new ArrayList<>();
        int totalCount = 0;
        Object2IntMap<String> metricsCountByDestination = new Object2IntOpenHashMap<>(1);

        boolean truncated = false;
        boolean allDestSuccess = true;
        for (FindResponse response : responses) {
            truncated |= response.isTruncated();
            allDestSuccess &= response.isAllDestSuccess();
            for (MetricKey key : response.getMetrics()) {
                if (metrics.size() >= limit) {
                    truncated = true;
                    break;
                }

                metrics.add(key);
            }

            totalCount += response.getTotalCount();

            for (var entry : response.getMetricsCountByDestination().entrySet()) {
                metricsCountByDestination.put(entry.getKey(), metricsCountByDestination.getInt(entry.getKey()) + entry.getValue());
            }
        }

        return new FindResponse(
                metrics,
                totalCount,
                metricsCountByDestination,
                truncated,
                allDestSuccess
        );
    }
}
