package ru.yandex.solomon.metrics.client;

import java.util.Objects;

import ru.yandex.solomon.labels.query.Selectors;

/**
 * @author Vladimir Gordiychuk
 */
public class FindRequest extends AbstractRequest {
    private final String folderId;
    private final Selectors selectors;
    private final int limit;
    private final int offset;
    private final boolean useNewFormat;

    private FindRequest(Builder builder) {
        super(builder);
        this.folderId = builder.folderId;
        this.selectors = Objects.requireNonNull(builder.selectors);
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.useNewFormat = builder.useNewFormat;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getFolderId() {
        return folderId;
    }

    public Selectors getSelectors() {
        return selectors;
    }

    public int getLimit() {
        return limit;
    }

    public int getOffset() {
        return offset;
    }

    public boolean isUseNewFormat() {
        return useNewFormat;
    }

    public static class Builder extends AbstractRequest.Builder<Builder> {
        private String folderId = "";
        private Selectors selectors;
        private int limit = Integer.MAX_VALUE;
        private int offset = 0;
        private boolean useNewFormat;

        public Builder setFolderId(String folderId) {
            this.folderId = folderId;
            return this;
        }
        public Builder setSelectors(Selectors selectors) {
            this.selectors = selectors;
            return this;
        }

        public Builder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder setOffset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder setUseNewFormat(boolean useNewFormat) {
            this.useNewFormat = useNewFormat;
            return this;
        }

        public FindRequest build() {
            return new FindRequest(this);
        }
    }
}
