package ru.yandex.solomon.metrics.client;

import java.util.List;
import java.util.Map;

import ru.yandex.solomon.model.MetricKey;

/**
 * @author Vladimir Gordiychuk
 */
public class FindResponse implements MetabaseStatusAware, CrossDcStatusAware {
    private final MetabaseStatus status;
    private final List<MetricKey> metrics;
    private final int totalCount;
    private final Map<String, Integer> metricsCountByDestination;
    private final boolean truncated;
    private final boolean allDestSuccess;

    public FindResponse(MetabaseStatus status) {
        this(status, List.of(), 0, Map.of(), false, false);
    }

    public FindResponse(
        List<MetricKey> keys,
        int totalCount,
        Map<String, Integer> metricsCountByDestination,
        boolean truncated,
        boolean allDestSuccess)
    {
        this(MetabaseStatus.OK, keys, totalCount, metricsCountByDestination, truncated, allDestSuccess);
    }

    public FindResponse(
        MetabaseStatus status,
        List<MetricKey> metrics,
        int totalCount,
        Map<String, Integer> metricsCountByDestination,
        boolean truncated,
        boolean allDestSuccess)
    {
        this.status = status;
        this.metrics = metrics;
        this.totalCount = totalCount;
        this.metricsCountByDestination = metricsCountByDestination;
        this.truncated = truncated;
        this.allDestSuccess = allDestSuccess;
    }

    public boolean isTruncated() {
        return truncated;
    }

    @Override
    public boolean isAllDestSuccess() {
        return allDestSuccess;
    }

    @Override
    public MetabaseStatus getStatus() {
        return status;
    }

    public List<MetricKey> getMetrics() {
        return metrics;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public Map<String, Integer> getMetricsCountByDestination() {
        return metricsCountByDestination;
    }

    @Override
    public String toString() {
        return "FindResponse{" +
                "status=" + status +
                ", metrics=" + metrics +
                ", totalCount=" + totalCount +
                ", metricsCountByDestination=" + metricsCountByDestination +
                ", truncated=" + truncated +
                ", allDestSuccess=" + allDestSuccess +
                '}';
    }
}
