package ru.yandex.solomon.metrics.client;

import ru.yandex.solomon.labels.query.Selectors;

/**
 * @author Vladimir Gordiychuk
 */
public class LabelNamesRequest extends AbstractRequest {
    private final String folderId;
    private final Selectors selectors;
    private final boolean useNewFormat;

    public LabelNamesRequest(Builder builder) {
        super(builder);
        this.folderId = builder.folderId;
        this.selectors = builder.selectors;
        this.useNewFormat = builder.useNewFormat;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getFolderId() {
        return folderId;
    }

    public Selectors getSelectors() {
        return selectors;
    }

    public boolean isUseNewFormat() {
        return useNewFormat;
    }

    public static class Builder extends AbstractRequest.Builder<Builder> {
        private String folderId = "";
        private Selectors selectors;
        private boolean useNewFormat;

        private Builder() {
        }

        public Builder setFolderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder setSelectors(Selectors selectors) {
            this.selectors = selectors;
            return this;
        }

        public Builder setUseNewFormat(boolean useNewFormat) {
            this.useNewFormat = useNewFormat;
            return this;
        }

        public LabelNamesRequest build() {
            return new LabelNamesRequest(this);
        }
    }
}
