package ru.yandex.solomon.metrics.client;

import java.util.Collections;
import java.util.Set;

/**
 * @author Vladimir Gordiychuk
 */
public class LabelNamesResponse implements MetabaseStatusAware {
    private final MetabaseStatus status;
    private final Set<String> names;

    public LabelNamesResponse(MetabaseStatus status) {
        this(status, Collections.emptySet());
    }

    public LabelNamesResponse(Set<String> names) {
        this(MetabaseStatus.OK, names);
    }

    private LabelNamesResponse(MetabaseStatus status, Set<String> names) {
        this.status = status;
        this.names = names;
    }

    @Override
    public MetabaseStatus getStatus() {
        return status;
    }

    public Set<String> getNames() {
        return names;
    }
}
