package ru.yandex.solomon.metrics.client;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.metabase.protobuf.LabelValidationFilter;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class LabelValuesRequest extends AbstractRequest {
    private final String folderId;
    private final Selectors selectors;
    private final Set<String> labelNames;
    private final String textSearch;
    private final LabelValidationFilter validationFilter;
    private final int limit;
    private final boolean useNewFormat;

    private LabelValuesRequest(Builder builder) {
        super(builder);
        this.folderId = builder.folderId;
        this.selectors = builder.selectors;
        this.labelNames = Set.copyOf(builder.names);
        this.limit = builder.limit;
        this.textSearch = builder.textSearch;
        this.validationFilter = builder.validationFilter;
        this.useNewFormat = builder.useNewFormat;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getFolderId() {
        return folderId;
    }

    public Selectors getSelectors() {
        return selectors;
    }

    public Set<String> getLabelNames() {
        return labelNames;
    }

    public int getLimit() {
        return limit;
    }

    public String getTextSearch() {
        return textSearch;
    }

    public LabelValidationFilter getValidationFilter() {
        return validationFilter;
    }

    public boolean isUseNewFormat() {
        return useNewFormat;
    }

    @ParametersAreNonnullByDefault
    public static class Builder extends AbstractRequest.Builder<Builder> {
        private String folderId = "";
        private Selectors selectors;
        private int limit;
        private String textSearch = "";
        private LabelValidationFilter validationFilter = LabelValidationFilter.ALL;
        private Set<String> names = Set.of();
        private boolean useNewFormat;

        private Builder() {
        }

        public Builder setFolderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder setSelectors(Selectors selectors) {
            this.selectors = selectors;
            return this;
        }

        public Builder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder setName(String labelName) {
            this.names = Set.of(labelName);
            return this;
        }

        public Builder setNames(Set<String> names) {
            this.names = names;
            return this;
        }

        public Builder setTextSearch(String text) {
            this.textSearch = text;
            return this;
        }

        public Builder setValidationFilter(LabelValidationFilter validationFilter) {
            this.validationFilter = validationFilter;
            return this;
        }

        public Builder setUseNewFormat(boolean useNewFormat) {
            this.useNewFormat = useNewFormat;
            return this;
        }

        public LabelValuesRequest build() {
            return new LabelValuesRequest(this);
        }
    }
}
