package ru.yandex.solomon.metrics.client;

import java.util.Collections;
import java.util.Map;

import ru.yandex.solomon.util.labelStats.LabelValuesStats;

/**
 * @author Vladimir Gordiychuk
 */
public class LabelValuesResponse implements MetabaseStatusAware {
    private final MetabaseStatus status;
    private final LabelValuesStats labelValuesStats;
    private final Map<String, Integer> metricsCountByDestination;

    public LabelValuesResponse(MetabaseStatus status) {
        this(status, new LabelValuesStats(Collections.emptyMap(), 0), Collections.emptyMap());
    }

    public LabelValuesResponse(LabelValuesStats labelValuesStats, Map<String, Integer> metricsCountByDestination) {
        this(MetabaseStatus.OK, labelValuesStats, metricsCountByDestination);
    }

    private LabelValuesResponse(
        MetabaseStatus status,
        LabelValuesStats labelValuesStats,
        Map<String, Integer> metricsCountByDestination)
    {
        this.status = status;
        this.labelValuesStats = labelValuesStats;
        this.metricsCountByDestination = metricsCountByDestination;
    }

    public LabelValuesStats getLabelValuesStats() {
        return labelValuesStats;
    }

    public Map<String, Integer> getMetricsCountByDestination() {
        return metricsCountByDestination;
    }

    @Override
    public MetabaseStatus getStatus() {
        return status;
    }
}
