package ru.yandex.solomon.metrics.client;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Throwables;

import ru.yandex.misc.lang.StringUtils;
import ru.yandex.solomon.metabase.api.protobuf.EMetabaseStatusCode;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class MetabaseStatus {
    public static final MetabaseStatus OK = MetabaseStatus.fromCode(EMetabaseStatusCode.OK, "");

    private final EMetabaseStatusCode code;
    @Nullable
    private final String description;

    public MetabaseStatus(EMetabaseStatusCode code, @Nullable String description) {
        this.code = code;
        this.description = description;
    }

    public static MetabaseStatus fromCode(EMetabaseStatusCode code, @Nullable String description) {
        return new MetabaseStatus(code, description);
    }

    public static MetabaseStatus fromThrowable(Throwable t) {
        // Couldn't find a cause with a Status
        return new MetabaseStatus(EMetabaseStatusCode.UNKNOWN, Throwables.getStackTraceAsString(t));
    }

    public EMetabaseStatusCode getCode() {
        return code;
    }

    public boolean isOk() {
        return code == EMetabaseStatusCode.OK;
    }

    public boolean isOkOrNoData() {
        return switch (getCode()) {
            case OK, NOT_FOUND, SHARD_NOT_FOUND -> true;
            default -> false;
        };
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        if (StringUtils.isEmpty(description)) {
            return code.toString();
        } else {
            return code + ": " + description;
        }
    }
}
