package ru.yandex.solomon.metrics.client;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.metabase.protobuf.LabelValidationFilter;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class MetricNamesRequest extends AbstractRequest {
    private final String folderId;
    private final Selectors selectors;
    private final String textSearch;
    private final LabelValidationFilter validationFilter;
    private final int limit;

    private MetricNamesRequest(Builder builder) {
        super(builder);
        this.folderId = builder.folderId;
        this.selectors = builder.selectors;
        this.textSearch = builder.textSearch;
        this.validationFilter = builder.validationFilter;
        this.limit = builder.limit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.folderId = this.folderId;
        builder.selectors = this.selectors;
        builder.textSearch = this.textSearch;
        builder.validationFilter = this.validationFilter;
        builder.limit = this.limit;
        return builder;
    }

    public String getFolderId() {
        return folderId;
    }

    public Selectors getSelectors() {
        return selectors;
    }

    public String getTextSearch() {
        return textSearch;
    }

    public LabelValidationFilter getValidationFilter() {
        return validationFilter;
    }

    public int getLimit() {
        return limit;
    }

    public static final class Builder extends AbstractRequest.Builder<Builder> {
        private String folderId = "";
        private Selectors selectors;
        private String textSearch;
        private LabelValidationFilter validationFilter;
        private int limit;

        private Builder() {
        }

        public Builder setFolderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder setSelectors(Selectors selectors) {
            this.selectors = selectors;
            return this;
        }

        public Builder setTextSearch(String textSearch) {
            this.textSearch = textSearch;
            return this;
        }

        public Builder setValidationFilter(LabelValidationFilter validationFilter) {
            this.validationFilter = validationFilter;
            return this;
        }

        public Builder setLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public MetricNamesRequest build() {
            return new MetricNamesRequest(this);
        }
    }
}
