package ru.yandex.solomon.metrics.client;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class MetricNamesResponse implements MetabaseStatusAware {

    private final MetabaseStatus status;
    private final List<String> names;
    private final boolean truncated;

    public MetricNamesResponse(MetabaseStatus status) {
        this(status, Collections.emptyList(), false);
    }

    public MetricNamesResponse(List<String> names, boolean truncated) {
        this(MetabaseStatus.OK, names, truncated);
    }

    private MetricNamesResponse(MetabaseStatus status, List<String> names, boolean truncated) {
        this.status = status;
        this.names = names;
        this.truncated = truncated;
    }

    public List<String> getNames() {
        return names;
    }

    public boolean isTruncated() {
        return truncated;
    }

    @Override
    public MetabaseStatus getStatus() {
        return status;
    }
}
