package ru.yandex.solomon.metrics.client;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.metrics.client.combined.FindAndReadManyRequest;
import ru.yandex.solomon.metrics.client.combined.FindAndReadManyResponse;
import ru.yandex.solomon.selfmon.AvailabilityStatus;

/**
 * @author Vladimir Gordiychuk
 */
public interface MetricsClient extends AutoCloseable {
    /**
     * Find by metrics by selectors in all meta storage's
     */
    CompletableFuture<FindResponse> find(FindRequest request);

    /**
     * Resolve metric by (name, labels) identifier
     */
    CompletableFuture<ResolveOneResponse> resolveOne(ResolveOneRequest request);

    /**
     * Resolve metrics by unique identifier (name, labels)
     */
    CompletableFuture<ResolveOneResponse> resolveOneWithName(ResolveOneWithNameRequest request);

    /**
     * Find metrics by list of labels in all meta storages
     */
    CompletableFuture<ResolveManyResponse> resolveMany(ResolveManyRequest request);

    /**
     * Find metrics by list of metric unique identifier (name, labels) in all meta storages
     */
    CompletableFuture<ResolveManyResponse> resolveManyWithName(ResolveManyWithNameRequest request);

    /**
     * Find all metric names by selectors
     */
    CompletableFuture<MetricNamesResponse> metricNames(MetricNamesRequest request);

    /**
     * Find by selector all unique label names
     */
    CompletableFuture<LabelNamesResponse> labelNames(LabelNamesRequest request);

    /**
     * Find by selector unique values by each label
     */
    CompletableFuture<LabelValuesResponse> labelValues(LabelValuesRequest request);

    /**
     * Find unique labels pair for specified selector
     */
    CompletableFuture<UniqueLabelsResponse> uniqueLabels(UniqueLabelsRequest request);

    /**
     * Read timeseries by key from storage's
     */
    CompletableFuture<ReadResponse> read(ReadRequest request);

    /**
     * Read a group of metrics by key from storage's with optional operations
     */
    CompletableFuture<ReadManyResponse> readMany(ReadManyRequest request);

    /**
     * @return availability of meta storage
     */
    AvailabilityStatus getMetabaseAvailability();

    /**
     * @return availability of data storage
     */
    AvailabilityStatus getStockpileAvailability();

    Stream<Labels> metabaseShards(String destination, Selectors selector);

    /** Fused find & readMany */
    CompletableFuture<FindAndReadManyResponse> findAndReadMany(FindAndReadManyRequest request);

    String getStockpileHostForShardId(String destination, int shardId);

    Collection<String> getDestinations();

    @Override
    void close();
}
