package ru.yandex.solomon.metrics.client;

import java.util.Optional;

import javax.annotation.Nullable;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.discovery.cluster.ClusterMapper;
import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.grpc.conf.GrpcConfigurationContext;
import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.TStockpileClientConfig;
import ru.yandex.solomon.config.protobuf.dataproxy.client.DataProxyClientConfig;
import ru.yandex.solomon.config.protobuf.metabase.client.TMetabaseClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.flags.FeatureFlagHolderStub;
import ru.yandex.solomon.flags.FeatureFlagsHolder;

/**
 * @author Oleg Baryshnikov
 */
@Configuration
@Import({
        GrpcConfigurationContext.class
})
public class MetricsClientContext {

    private final MetricsClientFactory factory;

    public MetricsClientContext(
        ThreadPoolProvider threadPool,
        MetricRegistry registry,
        ClusterMapper clusterMapper,
        Optional<LabelAllocator> labelAllocator,
        Optional<MetricsClientMetrics> metricsClientMetricsOpt,
        ClientOptionsFactory clientOptionsFactory)
    {
        factory = new MetricsClientFactory(
                threadPool,
                registry,
                clusterMapper,
                labelAllocator.orElse(Labels.allocator),
                metricsClientMetricsOpt.orElse(null),
                clientOptionsFactory
        );
    }

    @Bean
    public MetricsClient metricsClient(
            @Qualifier("ClientId") String clientId,
            TMetabaseClientConfig metabase,
            TStockpileClientConfig stockpile,
            Optional<DataProxyClientConfig> dataProxy,
            Optional<FeatureFlagsHolder> flagsHolder)
    {
        @Nullable DataProxyClientConfig dataProxyClientConfig = dataProxy.orElse(null);
        FeatureFlagsHolder featureFlagsHolder = flagsHolder.orElse(new FeatureFlagHolderStub());
        return factory.create(clientId, metabase, stockpile, dataProxyClientConfig, featureFlagsHolder);
    }

    @Bean
    public CheckerMetabase checkerMetabase(MetricsClient client) {
        return new CheckerMetabase(client);
    }

    @Bean
    public CheckerStockpile checkerStockpile(MetricsClient client) {
        return new CheckerStockpile(client);
    }
}
