package ru.yandex.solomon.metrics.client;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.metrics.client.combined.FindAndReadManyRequest;
import ru.yandex.solomon.metrics.client.combined.FindAndReadManyResponse;
import ru.yandex.solomon.selfmon.AvailabilityStatus;

/**
 * @author Alexey Trushkin
 */
class MetricsClientDelegate implements MetricsClient {

    private final MetricsClient metricsClient;

    protected MetricsClientDelegate(MetricsClient metricsClient) {
        this.metricsClient = metricsClient;
    }

    @Override
    public CompletableFuture<FindResponse> find(FindRequest request) {
        return metricsClient.find(request);
    }

    @Override
    public CompletableFuture<ResolveOneResponse> resolveOne(ResolveOneRequest request) {
        return metricsClient.resolveOne(request);
    }

    @Override
    public CompletableFuture<ResolveOneResponse> resolveOneWithName(ResolveOneWithNameRequest request) {
        return metricsClient.resolveOneWithName(request);
    }

    @Override
    public CompletableFuture<ResolveManyResponse> resolveMany(ResolveManyRequest request) {
        return metricsClient.resolveMany(request);
    }

    @Override
    public CompletableFuture<ResolveManyResponse> resolveManyWithName(ResolveManyWithNameRequest request) {
        return metricsClient.resolveManyWithName(request);
    }

    @Override
    public CompletableFuture<MetricNamesResponse> metricNames(MetricNamesRequest request) {
        return metricsClient.metricNames(request);
    }

    @Override
    public CompletableFuture<LabelNamesResponse> labelNames(LabelNamesRequest request) {
        return metricsClient.labelNames(request);
    }

    @Override
    public CompletableFuture<LabelValuesResponse> labelValues(LabelValuesRequest request) {
        return metricsClient.labelValues(request);
    }

    @Override
    public CompletableFuture<UniqueLabelsResponse> uniqueLabels(UniqueLabelsRequest request) {
        return metricsClient.uniqueLabels(request);
    }

    @Override
    public CompletableFuture<ReadResponse> read(ReadRequest request) {
        return metricsClient.read(request);
    }

    @Override
    public CompletableFuture<ReadManyResponse> readMany(ReadManyRequest request) {
        return metricsClient.readMany(request);
    }

    @Override
    public AvailabilityStatus getMetabaseAvailability() {
        return metricsClient.getMetabaseAvailability();
    }

    @Override
    public AvailabilityStatus getStockpileAvailability() {
        return metricsClient.getStockpileAvailability();
    }

    @Override
    public Stream<Labels> metabaseShards(String destination, Selectors selector) {
        return metricsClient.metabaseShards(destination, selector);
    }

    @Override
    public String getStockpileHostForShardId(String destination, int shardId) {
        return metricsClient.getStockpileHostForShardId(destination, shardId);
    }

    @Override
    public Collection<String> getDestinations() {
        return metricsClient.getDestinations();
    }

    @Override
    public CompletableFuture<FindAndReadManyResponse> findAndReadMany(FindAndReadManyRequest request) {
        return metricsClient.findAndReadMany(request);
    }

    @Override
    public void close() {
        metricsClient.close();
    }
}
