package ru.yandex.solomon.metrics.client;

import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.discovery.cluster.ClusterMapper;
import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.metabase.client.MetabaseClient;
import ru.yandex.metabase.client.MetabaseClientFactory;
import ru.yandex.monlib.metrics.labels.LabelAllocator;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.TStockpileClientConfig;
import ru.yandex.solomon.config.protobuf.dataproxy.client.DataProxyClientConfig;
import ru.yandex.solomon.config.protobuf.metabase.client.TMetabaseClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.dataproxy.client.DataProxyClient;
import ru.yandex.solomon.dataproxy.client.DataProxyClientFactory;
import ru.yandex.solomon.flags.FeatureFlagHolderStub;
import ru.yandex.solomon.flags.FeatureFlagsHolder;
import ru.yandex.stockpile.client.StockpileClient;
import ru.yandex.stockpile.client.StockpileClientFactory;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricsClientFactory {
    private final MetabaseClientFactory metabaseClientFactory;
    private final StockpileClientFactory stockpileClientFactory;
    private final LabelAllocator labelAllocator;
    private final MetricRegistry metricRegistry;
    private final DataProxyClientFactory dataProxyClientFactory;
    @Nullable
    private final MetricsClientMetrics metricsClientMetrics;

    public MetricsClientFactory(
            ThreadPoolProvider threadPool,
            MetricRegistry registry,
            ClusterMapper clusterMapper,
            ClientOptionsFactory clientOptionsFactory) {
        this(threadPool, registry, clusterMapper, Labels.allocator, null, clientOptionsFactory);
    }

    public MetricsClientFactory(
            ThreadPoolProvider threadPool,
            MetricRegistry registry,
            ClusterMapper clusterMapper,
            LabelAllocator labelAllocator,
            @Nullable MetricsClientMetrics metricsClientMetrics,
            ClientOptionsFactory clientOptionsFactory)
    {
        this.metricsClientMetrics = metricsClientMetrics;
        this.metabaseClientFactory = new MetabaseClientFactory(threadPool, clusterMapper, registry, clientOptionsFactory);
        this.stockpileClientFactory = new StockpileClientFactory(threadPool, clusterMapper, registry, clientOptionsFactory);
        this.dataProxyClientFactory = new DataProxyClientFactory(threadPool, registry, clientOptionsFactory);
        this.labelAllocator = labelAllocator;
        this.metricRegistry = registry;
    }

    public MetricsClient create(
            String clientId,
            TMetabaseClientConfig metabaseConfig,
            TStockpileClientConfig stockpileConfig)
    {
        return create(clientId, metabaseConfig, stockpileConfig, null, new FeatureFlagHolderStub());
    }

    public MetricsClient create(
            String clientId,
            TMetabaseClientConfig metabaseConfig,
            TStockpileClientConfig stockpileConfig,
            @Nullable DataProxyClientConfig dataProxyConfig,
            FeatureFlagsHolder flagsHolder)
    {
        Map<String, MetabaseClient> metabase = metabaseClientFactory.createClients(clientId, metabaseConfig);
        Map<String, StockpileClient> stockpile = stockpileClientFactory.createClients(clientId, stockpileConfig);
        DataProxyClient dataProxy = (dataProxyConfig != null)
                ? dataProxyClientFactory.createClient(clientId, dataProxyConfig)
                : null;
        return MetricsClients.create(
                metabaseConfig,
                metabase, stockpile, dataProxy,
                metricRegistry, labelAllocator,
                clientId, flagsHolder, metricsClientMetrics);
    }
}
