package ru.yandex.solomon.metrics.client;

import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;

import ru.yandex.solomon.math.operation.Metric;
import ru.yandex.solomon.model.MetricKey;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;

/**
 * @author Alexey Trushkin
 */
public class MetricsClientMetricsProxy extends MetricsClientDelegate {

    private final MetricsClientMetrics metricsClientMetrics;

    public MetricsClientMetricsProxy(MetricsClientMetrics metricsClientMetrics, MetricsClient backend) {
        super(backend);
        this.metricsClientMetrics = metricsClientMetrics;
    }

    private void hitMetricsRead(AbstractRequest request, @Nullable AggrGraphDataIterable timeseries) {
        if (timeseries == null) {
            return;
        }
        metricsClientMetrics.hitMetricsRead(request, timeseries.elapsedBytes(), timeseries.getRecordCount());
    }

    @Override
    public CompletableFuture<ReadResponse> read(ReadRequest request) {
        return super.read(request)
                .thenApply(readResponse -> {
                    hitMetricsRead(request, readResponse.getMetric().getTimeseries());
                    return readResponse;
                });
    }

    @Override
    public CompletableFuture<ReadManyResponse> readMany(ReadManyRequest request) {
        return super.readMany(request)
                .thenApply(readResponse -> {
                    for (Metric<MetricKey> metric : readResponse.getMetrics()) {
                        hitMetricsRead(request, metric.getTimeseries());
                    }
                    return readResponse;
                });
    }
}
