package ru.yandex.solomon.metrics.client;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.operation.Metric;
import ru.yandex.solomon.model.MetricKey;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public class ReadManyResponse implements StockpileStatusAware {
    private final StockpileStatus status;
    private final List<Metric<MetricKey>> metrics;

    public ReadManyResponse(StockpileStatus status) {
        this.status = status;
        this.metrics = Collections.emptyList();
    }

    public ReadManyResponse(List<Metric<MetricKey>> metrics) {
        this.status = StockpileStatus.OK;
        this.metrics = metrics;
    }

    public List<Metric<MetricKey>> getMetrics() {
        return metrics;
    }

    @Override
    public StockpileStatus getStatus() {
        return status;
    }
}
