package ru.yandex.solomon.metrics.client;

import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.math.operation.Metric;
import ru.yandex.solomon.model.MetricKey;
import ru.yandex.solomon.model.protobuf.MetricType;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;
import ru.yandex.stockpile.api.EProjectId;

/**
 * @author Vladimir Gordiychuk
 */
public final class ReadResponse implements StockpileStatusAware, CrossDcStatusAware {
    private Metric<MetricKey> metric;
    private StockpileStatus status;
    private final boolean allDestSuccess;

    public ReadResponse(MetricKey metricKey, StockpileStatus status) {
        this(metricKey, status, MetricType.DGAUGE, EProjectId.UNKNOWN, MetricArchiveImmutable.empty, false);
    }

    public ReadResponse(
            MetricKey metricKey,
            StockpileStatus status,
            MetricType type,
            EProjectId ownerProject,
            AggrGraphDataIterable source,
            boolean allDestSuccess)
    {
        this(new Metric<>(metricKey, type, ownerProject, source), status, allDestSuccess);
    }

    public ReadResponse(Metric<MetricKey> metric, StockpileStatus status, boolean allDestSuccess) {
        this.metric = metric;
        this.status = status;
        this.allDestSuccess = allDestSuccess;
    }

    public MetricKey getMetricKey() {
        return metric.getKey();
    }

    @Override
    public StockpileStatus getStatus() {
        return status;
    }

    public Metric<MetricKey> getMetric() {
        return metric;
    }

    public MetricType getType() {
        return getMetric().getType();
    }

    public AggrGraphDataListIterator getIterator() {
        return getSource().iterator();
    }

    public AggrGraphDataIterable getSource() {
        return metric.getTimeseries();
    }

    @Override
    public boolean isAllDestSuccess() {
        return allDestSuccess;
    }
}
