package ru.yandex.solomon.metrics.client;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ResolveManyRequest extends AbstractRequest {

    private final Labels commonLabels;
    private final List<Labels> labelsList;

    private ResolveManyRequest(Builder builder) {
        super(builder);
        this.commonLabels = builder.commonLabels;
        this.labelsList = builder.labelsList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Labels getCommonLabels() {
        return commonLabels;
    }

    public List<Labels> getLabelsList() {
        return labelsList;
    }

    public static class Builder extends AbstractRequest.Builder<Builder> {

        private Labels commonLabels = Labels.empty();
        private List<Labels> labelsList = Collections.emptyList();

        public Builder setCommonLabels(Labels commonLabels) {
            this.commonLabels = commonLabels;
            return this;
        }

        public Builder setLabelsList(List<Labels> labelsList) {
            this.labelsList = labelsList;
            return this;
        }

        public ResolveManyRequest build() {
            return new ResolveManyRequest(this);
        }
    }
}
