package ru.yandex.solomon.metrics.client;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.MetricKey;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ResolveManyResponse implements MetabaseStatusAware {

    public final MetabaseStatus status;
    private final List<MetricKey> metrics;

    public ResolveManyResponse(MetabaseStatus status) {
        this.status = status;
        this.metrics = Collections.emptyList();
    }

    public ResolveManyResponse(List<MetricKey> metrics) {
        this.status = MetabaseStatus.OK;
        this.metrics = metrics;
    }

    @Override
    public MetabaseStatus getStatus() {
        return status;
    }

    public List<MetricKey> getMetrics() {
        return metrics;
    }
}
