package ru.yandex.solomon.metrics.client;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.model.MetricKeyPartial;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ResolveManyWithNameRequest extends AbstractRequest {

    private final Labels commonLabels;
    private final List<MetricKeyPartial> metrics;

    private ResolveManyWithNameRequest(Builder builder) {
        super(builder);
        this.commonLabels = builder.commonLabels;
        this.metrics = builder.metrics;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Labels getCommonLabels() {
        return commonLabels;
    }

    public List<MetricKeyPartial> getMetrics() {
        return metrics;
    }

    public static class Builder extends AbstractRequest.Builder<Builder> {

        private Labels commonLabels = Labels.empty();
        private List<MetricKeyPartial> metrics = Collections.emptyList();

        public Builder setCommonLabels(Labels commonLabels) {
            this.commonLabels = commonLabels;
            return this;
        }

        public Builder setMetrics(List<MetricKeyPartial> metrics) {
            this.metrics = metrics;
            return this;
        }

        public ResolveManyWithNameRequest build() {
            return new ResolveManyWithNameRequest(this);
        }
    }
}
