package ru.yandex.solomon.metrics.client;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ResolveOneRequest extends AbstractRequest {

    private final Labels labels;

    private ResolveOneRequest(Builder builder) {
        super(builder);
        this.labels = builder.labels;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Labels getLabels() {
        return labels;
    }

    public static class Builder extends AbstractRequest.Builder<Builder> {

        private Labels labels = Labels.empty();

        public Builder setLabels(Labels labels) {
            this.labels = labels;
            return this;
        }

        public ResolveOneRequest build() {
            return new ResolveOneRequest(this);
        }
    }
}
