package ru.yandex.solomon.metrics.client;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.MetricKey;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ResolveOneResponse implements MetabaseStatusAware {

    public final MetabaseStatus status;
    private final MetricKey metric;

    public ResolveOneResponse(MetabaseStatus status) {
        this.status = status;
        this.metric = MetricKey.unknown();
    }

    public ResolveOneResponse(MetricKey metric) {
        this.status = MetabaseStatus.OK;
        this.metric = metric;
    }

    @Override
    public MetabaseStatus getStatus() {
        return status;
    }

    public MetricKey getMetric() {
        return metric;
    }
}
