package ru.yandex.solomon.metrics.client;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.model.MetricKeyPartial;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ResolveOneWithNameRequest extends AbstractRequest {

    private final MetricKeyPartial metric;

    private ResolveOneWithNameRequest(Builder builder) {
        super(builder);
        this.metric = Objects.requireNonNull(builder.metric);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public MetricKeyPartial getMetric() {
        return metric;
    }

    public static class Builder extends AbstractRequest.Builder<Builder> {

        private MetricKeyPartial metric = null;

        public Builder setMetric(MetricKeyPartial metric) {
            this.metric = metric;
            return this;
        }

        public ResolveOneWithNameRequest build() {
            return new ResolveOneWithNameRequest(this);
        }
    }
}
