package ru.yandex.solomon.metrics.client;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.metabase.api.protobuf.EMetabaseStatusCode;
import ru.yandex.stockpile.api.EStockpileStatusCode;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ResponseValidationUtils {

    public static void ensureMetabaseStatusValid(MetabaseStatus status) {
        if (status.getCode() != EMetabaseStatusCode.OK) {
            throw new MetabaseClientException(status);
        }
    }

    public static void ensureStockpileStatusValid(StockpileStatus status) {
        if (status.getCode() != EStockpileStatusCode.OK) {
            throw new StockpileClientException(status);
        }
    }
}
