package ru.yandex.solomon.metrics.client;

import org.openjdk.jol.info.GraphLayout;

import ru.yandex.solomon.model.point.DataPoint;
import ru.yandex.solomon.model.timeseries.GraphData;
import ru.yandex.solomon.util.time.Interval;

/**
 * @author Vladimir Gordiychuk
 */
public final class TimeSeriesSizeCounter {
    private static final long GRAPH_DATA_SIZE = sizeOf(GraphData.empty);
    private static final long POINT_SIZE = sizeOf(GraphData.of(new DataPoint(System.currentTimeMillis(), 1))) - GRAPH_DATA_SIZE;

    private TimeSeriesSizeCounter() {
    }

    public static long estimatedLoadSizeInBytes(
        int linesCount,
        Interval interval,
        long gridMillis)
    {
        long lineSize = TimeSeriesSizeCounter.estimateLineLoadSizeInBytes(interval, gridMillis);
        return lineSize * linesCount;
    }

    public static long estimateLineLoadSizeInBytes(Interval interval, long gridMillis) {
        long positiveGridMillis = gridMillis > 0 ? gridMillis : 15_000;
        long durationMillis = interval.duration().toMillis();
        long countPoints = durationMillis / positiveGridMillis;
        return GRAPH_DATA_SIZE + countPoints * POINT_SIZE;
    }

    private static long sizeOf(GraphData graphData) {
        return GraphLayout.parseInstance(graphData).totalSize();
    }
}
