package ru.yandex.solomon.metrics.client;

import java.util.Collections;
import java.util.Set;

import ru.yandex.solomon.labels.query.Selectors;
import ru.yandex.solomon.util.collection.Nullables;

import static java.util.Objects.requireNonNull;

/**
 * @author Vladimir Gordiychuk
 */
public class UniqueLabelsRequest extends AbstractRequest {
    private final String folderId;
    private final Selectors selectors;
    private final Set<String> labels;
    private final boolean useNewFormat;

    public UniqueLabelsRequest(Builder builder) {
        super(builder);
        this.folderId = Nullables.orEmpty(builder.folderId);
        this.selectors = requireNonNull(builder.selectors);
        this.labels = requireNonNull(builder.labels);
        this.useNewFormat = builder.useNewFormat;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getFolderId() {
        return folderId;
    }

    public Selectors getSelectors() {
        return selectors;
    }

    public Set<String> getLabels() {
        return labels;
    }

    public boolean isUseNewFormat() {
        return useNewFormat;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder extends AbstractRequest.Builder<Builder> {
        private String folderId;
        private Selectors selectors;
        private Set<String> labels = Collections.emptySet();
        private boolean useNewFormat;

        public Builder() {
        }

        public Builder(UniqueLabelsRequest request) {
            super(request);
            this.folderId = request.getFolderId();
            this.selectors = request.getSelectors();
            this.labels = request.getLabels();
            this.useNewFormat = request.useNewFormat;
        }

        public Builder setFolderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder setSelectors(Selectors selectors) {
            this.selectors = selectors;
            return this;
        }

        public Builder setLabels(Set<String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder setUseNewFormat(boolean useNewFormat) {
            this.useNewFormat = useNewFormat;
            return this;
        }

        public UniqueLabelsRequest build() {
            return new UniqueLabelsRequest(this);
        }
    }
}
